﻿<%@ Control Language="vb" AutoEventWireup="false" CodeBehind="SolderFeederStationPortGraphic.ascx.vb" Inherits="Web.SolderFeederStationPortGraphic" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<asp:UpdatePanel runat="server" ID="UpdatePanelGrafica" UpdateMode="Conditional" ChildrenAsTriggers="false" class="visual-block">
<ContentTemplate>

        <telerik:RadHtmlChart runat="server" ID="LineChart" BorderStyle="None" Width="100%" Height="100%" BackColor="Transparent" BorderColor="white" Transitions="false" Skin="Silk" EnableViewState="false" Visible="false">
            <Appearance>
                <FillStyle BackgroundColor="Transparent"></FillStyle>
            </Appearance>
            <ChartTitle Text="Gráfica">
                <Appearance Align="Center" BackgroundColor="Transparent">
                    <TextStyle FontSize="16" Padding="" Margin="-8 0 0 0" Color="white" Bold="false" FontFamily="Myriad W01" />
                </Appearance>
            </ChartTitle>
            <Legend>
                <Appearance BackgroundColor="Transparent" Position="Top"></Appearance>
            </Legend>
            <PlotArea>
                <YAxis AxisCrossingValue="0" Color="black" Width="1">
                    <LabelsAppearance DataFormatString="{0}" RotationAngle="0" Skip="0" Step="1">
                        <TextStyle FontSize="14" Padding="" Margin="" Color="red" FontFamily="Myriad W01" />
                    </LabelsAppearance>
                    <TitleAppearance Position="Top" RotationAngle="360" Text="(ºC)">
                        <TextStyle FontSize="14" Padding="0 -20 0 0" Margin="-25 0 0 0" Bold="true" Color="red" FontFamily="Myriad W01" />
                    </TitleAppearance>
                </YAxis>
                <AdditionalYAxes>
                    <telerik:AxisY Name="AdditionalAxis" Color="black" Width="1">
                        <TitleAppearance Position="Top" RotationAngle="360" Text="(%)">
                            <TextStyle FontSize="14" Padding="0 0 0 -20" Bold="true" Margin="-25 0 0" Color="#4578fa" />
                        </TitleAppearance>
                        <LabelsAppearance>
                            <TextStyle Color="#4578fa" FontSize="14" FontFamily="Myriad W01" />
                        </LabelsAppearance>
                    </telerik:AxisY>
                </AdditionalYAxes>
                <XAxis BaseUnit="Seconds" Color="#515151">
                    <LabelsAppearance DataFormatString="{0}" RotationAngle="0" Skip="0">
                        <TextStyle FontSize="14" FontFamily="Myriad W01" />
                    </LabelsAppearance>
                    <TitleAppearance Position="Bottom" RotationAngle="0" Text="Seg.">
                        <TextStyle FontSize="14" Margin="-12 -35 0 0" FontFamily="Myriad W01" Bold="true" />
                    </TitleAppearance>
                </XAxis>
            </PlotArea>
        </telerik:RadHtmlChart>


        <!--- Controles ocultos y timer-->
        <asp:HiddenField ID="hdnTicks" runat="server" Value="0" />
        <asp:HiddenField ID="hdnTicks_ant" runat="server" Value="0" />
        <asp:HiddenField ID="hdnHoraInicioEjecucion" runat="server" Value="0" />
        <asp:HiddenField ID="hdnTotalDatosRecogidos" runat="server" Value="0" />
        <asp:HiddenField ID="hdnTiempoMarca" runat="server" Value="10" />
        <asp:HiddenField ID="hdnEscalaTemp" runat="server" Value="CELSIUS" />
        <asp:HiddenField ID="hdnCambioEscala" runat="server" Value="0" />
        <asp:HiddenField ID="hdnVentanaTiempo" runat="server" Value="30" />
        <asp:HiddenField ID="hdnPuerto" runat="server" />
        <asp:HiddenField ID="hdnTempo" runat="server" Value="0" />
        <asp:Timer ID="TimerGrafica" runat="server" Interval="250" OnTick="TimerGrafica_Tick"></asp:Timer>

        <!-- control ventanas desplazamiento -->
        <asp:HiddenField ID="hdnVentanaTiempoMax" runat="server" />
        <asp:HiddenField ID="hdnVentanaTiempoMin" runat="server" />
        <asp:HiddenField ID="hdnVentanaFinal" runat="server" />

        <!-- Valores de referencia de la gráfica -->
        <asp:HiddenField ID="hdnTempSelected" runat="server" Value="" />
        <asp:HiddenField ID="hdnExtTCTempSelected" runat="server" Value="" />

        <!-- Inicialización del control gráfica -->
        <asp:HiddenField ID="hdn_IP_Servidor" runat="server" />
        <asp:HiddenField ID="hdn_ID_Estacion" runat="server" />
        <asp:HiddenField ID="hdn_IdUsuarioWeb" runat="server" />
        <asp:HiddenField ID="hdn_UdTemperatura" runat="server" />

    </ContentTemplate>
    <Triggers>
        <asp:AsyncPostBackTrigger ControlID="TimerGrafica" EventName="Tick" />
    </Triggers>
</asp:UpdatePanel>
